Attribute VB_Name = "enigma_keygen_ide"
' Key generation constants
Public Const ERROR_UNKNOWN = &HFFFFFFFF
Public Const ERROR_OK = &H0
Public Const ERROR_KEY_BUFFER_NOT_ALLOCATED = &H1
Public Const ERROR_KEY_BUFFER_LESS = &H2
Public Const ERROR_REGINFO_BUFFER_NOT_ALLOCATED = &H3
Public Const ERROR_REGINFO_BUFFER_EMPTY = &H4
Public Const ERROR_HARDWARE_TYPE_UNKNOWN = &H5
Public Const ERROR_HARDWARE_ID = &H6
Public Const ERROR_HARDWARE_BUFFER_NOT_ALLOCATED = &H7
Public Const ERROR_HARDWARE_BUFFER_EMPTY = &H8
Public Const ERROR_INVALID_CONSTANT_D = &H9
Public Const ERROR_INVALID_CONSTANT_N = &HA
Public Const ERROR_INVALID_CONSTANT_A = &HB
Public Const ERROR_INVALID_CONSTANT_B = &HC
Public Const ERROR_PROJECT_FILE_NOT_FOUND = &HD
Public Const ERROR_PROJECT_FILE_INVALID = &HE
Public Const ERROR_INVALID_CONSTANT_E = &HF
Public Const ERROR_INVALID_KEYTYPE = &H10
Public Const ERROR_INVALID_REGINFO = &H11

' Hardware locking type constants
Public Const HID_ERROR = 0
Public Const HID_HARDDISK = 1
Public Const HID_VOLUMENAME = 2
Public Const HID_CPUTYPE = 4
Public Const HID_COMPUTERNAME = 8
Public Const HID_MOTHERBOARDBIOS = 16
Public Const HID_WINDOWSSERIAL = 32
Public Const HID_HDDSERIAL = 64

' Number of crypted sections
Public Const NUMBER_OF_CRYPTED_SECTIONS = 16

' Key type
Public Const KEY_TYPE_LONG = 0
Public Const KEY_TYPE_SHORT = 1

' Key format
Public Const KEY_FORMAT_10 = 10
Public Const KEY_FORMAT_16 = 16
Public Const KEY_FORMAT_32 = 32
Public Const KEY_FORMAT_64 = 64

Public Type TGenKeyParams
    KeyType As Byte
    KeyFormat As Byte
    Reserved3 As Byte
    Reserved4 As Byte
    Key As String ' Key buffer
    KeyLen As Long ' Key buffer length
    RegInfo As String ' User info buffer
    RegInfoLen As Long ' User info buffer length
    UseKeyExpiration As Byte
    Reserved1 As Byte
    ExpirationYear As Integer ' ***
    ExpirationMonth As Byte ' *** Key expiration date
    ExpirationDay As Byte   ' ***
    UseHardwareLocking As Byte
    Reserved2 As Byte
    HardwareID As String ' Hardware locking info
    EncryptedSections(NUMBER_OF_CRYPTED_SECTIONS - 1) As Byte
    D As String ' Secure constants, get this from project file (GetABDN.exe utility)
    N As String ' Secure constants
    A As String ' Secure constants
    B As String ' Secure constants
End Type

Public Type TVerifyKey
    Key As String
    KeyType As Byte
    KeyFormat As Byte
    Reserved As Integer
    RegInfo As String
    CreateDay As Byte
    CreateMonth As Byte
    CreateYear As Integer
    UseKeyExpiration As Byte
    Reserved2 As Byte
    ExpirationYear As Integer
    ExpirationMonth As Byte
    ExpirationDay As Byte
    UseHardwareLocking As Byte
    HardwareIDType As Byte
    HardwareID As String
    EncryptedSections(NUMBER_OF_CRYPTED_SECTIONS - 1) As Byte
    N As String ' Secure constants, get this from project file (GetABDEN.exe utility)
    E As String ' Secure constants
    B As String ' Secure constants
    A As String ' Secure constants
End Type

'Declaration of keygen.dll functions

Public Declare Function KG_GenerateRegistrationKey Lib "keygen.dll" (ByRef GenKeyParams As TGenKeyParams) As Long
Public Declare Function KG_GenerateRegistrationKeyFromProject Lib "keygen.dll" (ByVal ProjectName As String, ByRef GenKeyParams As TGenKeyParams) As Long

Public Declare Function KG_VerifyRegistrationInfo Lib "keygen.dll" (ByRef VerifyKey As TVerifyKey) As Long
Public Declare Function KG_VerifyRegistrationInfoFromProject Lib "keygen.dll" (ByVal ProjectName As String, ByRef VerifyKey As TVerifyKey) As Long
